/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.ui.hud.impl;

import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.framework.msdf.Fonts;
import Krasnodar.rockstarnew.framework.objects.BorderRadius;
import Krasnodar.rockstarnew.ui.hud.HudList;
import Krasnodar.rockstarnew.utility.animation.base.Animation;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import Krasnodar.rockstarnew.utility.colors.Colors;
import net.minecraft.class_1802;

public class ChatCooldown
extends HudList {
    private final Animation fadeAnimation = new Animation(200L, 0.0f, Easing.QUAD_IN_OUT);
    private static long lastMessageTime = 0L;
    private static final long COOLDOWN_MS = 1000L;

    public ChatCooldown() {
        super("hud.chat_cooldown", "icons/hud/chat.png");
    }

    public static void onMessageSent() {
        lastMessageTime = System.currentTimeMillis();
    }

    private long getRemainingCooldown() {
        long elapsed = System.currentTimeMillis() - lastMessageTime;
        return Math.max(0L, 1000L - elapsed);
    }

    @Override
    public void update(UIContext context) {
        long remaining = this.getRemainingCooldown();
        this.fadeAnimation.update(remaining > 0L ? 1.0f : 0.0f);
        if (this.fadeAnimation.getValue() > 0.01f) {
            this.width = 150.0f;
            this.height = 24.0f;
        } else {
            this.width = 0.0f;
            this.height = 0.0f;
        }
        super.update(context);
    }

    @Override
    public void render(UIContext context) {
        String text;
        if (this.fadeAnimation.getValue() < 0.01f) {
            return;
        }
        float alpha = this.fadeAnimation.getValue();
        float x = this.x;
        float y = this.y;
        context.drawRoundedRect(x, y, this.width, this.height, BorderRadius.all(6.0f), Colors.getBackgroundColor().withAlpha(200.0f * alpha));
        context.drawItem(class_1802.field_8634, x + 4.0f, y + 4.0f, 1.0f);
        long remaining = this.getRemainingCooldown();
        if (remaining > 0L) {
            float seconds = (float)remaining / 1000.0f;
            text = String.format("\u041f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435 %.1f \u0441\u0435\u043a", Float.valueOf(seconds));
        } else {
            text = "\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430 \u0437\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u0430\u0441\u044c!";
        }
        context.drawText(Fonts.MEDIUM.getFont(9.0f), text, x + 26.0f, y + (this.height - 9.0f) / 2.0f, Colors.getTextColor().withAlpha(255.0f * alpha));
    }
}

